/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PIConnectionDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCConnectionClient;
import com.ibm.hsc.command.PICmdOutputUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class PISystemConnectionList {
    private static final int NUM_VALID_PARMS = 3;
    private String m_resourceType;
    private String m_format;
    private boolean m_header;
    private HashMap m_validParms = new HashMap(7, 0.5f);
    private PIHSCConnectionClient m_connectionClient = null;
    private String m_delimiter = ",";
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PISystemConnectionList(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-F", null);
        this.m_validParms.put("--header", null);
    }

    private void doConnectionObjList() throws PIHscClientException {
        String[] stringArray;
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, PIConnectionDataBean.ALL_KEYS, PIConnectionDataBean.ALL_KEYS.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(PIConnectionDataBean.ALL_KEYS, this.m_format, this.m_delimiter);
        } else {
            stringArray = PIConnectionDataBean.ALL_KEYS;
        }
        Vector vector = this.m_connectionClient.getConnectionDataBeans(stringArray);
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void performCommand() throws PIHscClientException {
        String string = null;
        this.checkParameters();
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string, null);
        this.m_connectionClient = pIHSCClientObjectFactory.createConnectionClient();
        this.doConnectionObjList();
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (this.m_resourceType == null || !"all".equals(this.m_resourceType)) {
            string = string + ", -r";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this.m_header && this.m_format == null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_HEADER_PARM", null, null);
        }
    }

    private void mapParameters(HashMap hashMap) {
        this.m_resourceType = (String)hashMap.get("-r");
        this.m_format = (String)hashMap.get("-F");
        String string = (String)hashMap.get("--header");
        this.m_header = string != null;
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "LSSYSCONN_HELP"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PISystemConnectionList pISystemConnectionList = new PISystemConnectionList(pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pISystemConnectionList.m_validParms);
            pISystemConnectionList.mapParameters(hashMap);
            pISystemConnectionList.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

